function [adm_params, L] = update_adm_params(model)

% Updates the parameters of the ADM. It also returns the value of the
% augmented Lagrangian function.

[N, D] = size(model.X);
adm_params = model.adm_params;
bp_params = model.bp_params;

num_mod = numel(bp_params);

prev_norms = [adm_params.norm];
norms = zeros(size(prev_norms,1)+1, num_mod);
if ~isempty(prev_norms), norms(1:end-1,:) = prev_norms; end

R = 0; Lang = 0;
if model.sbp
    fix_sum = 1/num_mod;
else
    fix_sum = 1;
end
for i = 1:num_mod
        %%% Update the Lagrange multipliers, Lambda, and the penalty parameter, mu
        adm_params(i).Lambda = adm_params(i).Lambda + adm_params(i).mu * (model.X - bp_params(i).M(1:N,:)*bp_params(i).A);
        adm_params(i).mu = min(adm_params(i).mu * model.rho, model.max_mu);
        
        %%% Calculate the norm of the diff between the latent space and the
        %%% back projections.
        norms(end,i) = norm(model.X - [bp_params(i).K_tilda ones(N,1)] * bp_params(i).A, 'fro');
        adm_params(i).norm = norms(:,i);

        
        R = R + fix_sum * .5 * bp_params(i).lambda * trace(bp_params(i).A(1:N,:)' * bp_params(i).K_tilda * bp_params(i).A(1:N,:));
        Lang = Lang + fix_sum * trace(adm_params(i).Lambda' * (model.X - bp_params(i).M(1:N,:) * bp_params(i).A));
end

L = R + Lang + fix_sum * adm_params(1).mu * sum(norms(end,:));

end