function model = ready2min(data_in, model)

% Prepares the data for the optimization of the GPLVM. It first stacks
% all the parameters (hyperparameters from all the views and latent
% variables) in a vector X. Then it calls the optimization function to find
% the best set of parameters. Finally, it remaps the new vector X to the
% corresponding parameters.

num_mod = numel(data_in);

if model.bp
    X_tmp = model.bp_params.A;
else
    X_tmp = model.X;
end
[N, D] = size(X_tmp);

%% Collect all the parameters in one single vector X
hyp = [];
for i = 1:num_mod
    hyp = [hyp; model.hyp{i}.cov(:); model.hyp{i}.lik(:)];
end

X = [X_tmp(:); hyp(:)];

% options = optimset('GradObj','on');
% options = optimset(options,'LargeScale','off');
% options = optimset(options,'DerivativeCheck','on');
% options = optimset(options,'Display','iter');
% options = optimset(options,'MaxIter',150);
% options = optimset(options,'TolFun',1e-6);
% options = optimset(options,'TolX',1e-6);
% [X, fX] = fminunc(@gplvm_fun, X, options, data_in, model);
% Iter = 500; p.length = -Iter; p.method = 'CG'; %p.verbosity = 3;
% [X, fX, iter] = minimize_new(X, @gplvm_fun, p, data_in, model);

%% Optimize the DS-GPLVM
options.METHOD = 'scg';
options.cgUpdate = 1;
options.maxFunEvals = 30;
options.maxIter=1000;
if model.sbp || model.ibp
    options.maxFunEvals = 10;       % Change this for more or less iterations.
end

% options.DERIVATIVECHECK = 'on';
[X, fX] = minFunc(@ds_gplvm_fun, X, options, data_in, model);
model.fX = fX(end);

%% Update the parameters of the model
rest = X(N*D+1:end);        % holds the updated hyper-parameters

%%%% Updated the latent space
if model.bp
    model.bp_params.A = reshape(X(1:N*D), N, D);
    model.X = [model.bp_params.K ones(N-1,1)]* model.bp_params.A;
else
    model.X = reshape(X(1:N*D), N, D);
end

%%%% Update the hyper-parameters
clear hyp;
cov_param = eval(feval(model.covfunc{:}));
lik_param = eval(feval(model.likfunc));
for i = 1:num_mod
    hyp{i}.cov = rest((i-1)*(cov_param+lik_param)+1:i*(cov_param+lik_param)-lik_param);
    hyp{i}.lik = rest((i-1)*(cov_param+lik_param)+cov_param+1:i*(cov_param+lik_param));
end

model.hyp = hyp;
end