function [Xz, mapping] = myLDA(X, labels)

% Finds a discriminative subpsace of the input data based on Linear
% Discriminant Analysis. The size of the spaces is at most C-1, where C is
% the number of classes.

[N,D] = size(X);

X = standardize(X, 1);

clusters = length(unique(labels));
dim = min(D,clusters-1);


labels_map = zeros(N, clusters);
for c = 1:clusters
    labels_map(:, c) = labels == c;
end
N_c = 1./sum(labels_map); N_c = diag(N_c);
W = labels_map * N_c * labels_map';
W = eye(N) - W;
S_w = X' * W * X / N;
W_g = ones(N,1) * ones(1,N) / N;
W_g = eye(N) - W_g;
S_t = X' * W_g * X / N;
S_b = S_t - S_w;
B = W_g - W;

S_b(isnan(S_b)) = 0; S_w(isnan(S_w)) = 0;
S_b(isinf(S_b)) = 0; S_w(isinf(S_w)) = 0;

[V, L] = eig(S_b, S_w);
L(isnan(L)) = 0;
[L, index] = sort(diag(L), 'descend');
V = V(:,index);

mapping = V(:,1:dim);
Xz = X*mapping;
end