function model = ds_gplvm_test(Y, model, varargin)

% It projects the input data to the learned manifold and applies the
% classification using the k-NN classifier. If indices for testing and
% validation were specified at the initialization stage, it also calculates
% the predictions of the corresponding sets.

num_mod = numel(Y);
[N, D] = size(model.X);

bp_params = model.bp_params;

labels = model.labels_full{1}(model.ind{1});
outK_train = cell(num_mod,1);

if model.validation
    Y_val = varargin{1};
    Y_test = varargin{2};
    labels_val = model.labels_full{1}(model.ind{2});
    for i = 1:numel(Y)
        labels_test{i} = model.labels_full{i}(model.ind{3}{i});
    end
    outK_val = cell(num_mod,1); outK_test = cell(num_mod,1);
    outK_tilda_val = 0; outK_tilda_test = 0;
end

%% Project the data to the manifold and classify them.
for i = 1:num_mod
    
    % Create the kernels
    if model.validation
        outK_val{i} = covSEisoU(log(bp_params(i).gamma), Y{i}, Y_val{i});
        outK_test{i} = covSEisoU(log(bp_params(i).gamma), Y{i}, Y_test{i});
    end
    outK_train{i} = bp_params(i).K;
    
    
    if model.sbp
        outK_tilda_train = [bp_params(1).K_tilda; ones(1, size(bp_params(1).K_tilda,2))];
        
        % project to the manifold and call the k-NN classifier.
        if i == num_mod
            m_latent = outK_tilda_train' * bp_params(1).A;
            [ac_train, labels_train] = model_classify(m_latent, labels, model.X, labels, 1);
            model.out.labels_train = labels_train;
            fprintf('\rAccuracy on train data: %f\r', ac_train);
        end
                
        if model.validation % same for the validation and test set (if we have any)
            outK_tilda_val = outK_tilda_val + outK_val{i} .* bp_params(i).w;
            outK_tilda_test = outK_tilda_test + outK_test{i} .* bp_params(i).w;
                        
            if i == num_mod
                outK_tilda_val = [outK_tilda_val; ones(1, size(outK_tilda_val,2))];
                outK_tilda_test = [outK_tilda_test; ones(1, size(outK_tilda_test,2))];
                
                m_latent = outK_tilda_val' * bp_params(1).A;
                [ac_val, out_labels_val] = model_classify(m_latent, labels_val, model.X, labels, 1);
                model.out.labels_val = out_labels_val;
                fprintf('Accuracy on val data: %f\r', ac_val);
                
                m_latent = outK_tilda_test' * bp_params(1).A;
                [ac_test, out_labels_test] = model_classify(m_latent, labels_test{1}, model.X, labels, 1);
                model.out.labels_test = out_labels_test;
                fprintf('Accuracy on test data: %f\r', ac_test);
            end
        end
    elseif model.ibp || model.bp       % same as above for the IBP case and the standard BP (Caution for BP we have only 1 view).
        outK_train{i} = [outK_train{i}; ones(1, size(outK_train{i},2))];
        
        m_latent = outK_train{i}'*bp_params(i).A;
        [ac_train(i), labels_train] = model_classify(m_latent, labels, model.X, labels, 1);
        model.out.labels_train{i} = labels_train;
        fprintf('\rView %d: Accuracy on train data: %f\r',i, ac_train(i));
        
        if model.validation
            outK_val{i} = [outK_val{i}; ones(1, size(outK_val{i},2))];
            outK_test{i} = [outK_test{i}; ones(1, size(outK_test{i},2))];
            
            m_latent = outK_val{i}'*bp_params(i).A;
            [ac_val(i), out_labels_val] = model_classify(m_latent, labels_val, model.X, labels, 1);
            model.out.labels_val{i} = out_labels_val;
            fprintf('View %d: Accuracy on val data: %f\r',i, ac_val(i));
            
            m_latent = outK_test{i}'*bp_params(i).A;
            [ac_test(i), out_labels_test] = model_classify(m_latent, labels_test{i}, model.X, labels, 1);
            model.out.labels_test{i} = out_labels_test;
            fprintf('View %d: Accuracy on test data: %f\r',i, ac_test(i));
        end
    end
end

%% Return the predictions
model.out.ac_train = [model.out.ac_train; ac_train];
if model.validation
    model.out.ac_val = [model.out.ac_val; ac_val];
    model.out.ac_test = [model.out.ac_test; ac_test];
end

end