function model = ds_gplvm_adm(data_in, model)

[N,D] = size(model.X);
num_mod = numel(data_in);

dat_norm = zeros(num_mod,1);
Y = cell(num_mod,1); Y_val = cell(num_mod,1); Y_test = cell(num_mod,1);
for i = 1:numel(data_in)
    Y{i} = standardize(data_in{i}(model.ind{1},:), 1);
    dat_norm(i) = norm(Y{i},'fro');
    if model.validation
        Y_val{i} = standardize(data_in{i}(model.ind{2}, :), 1);
        Y_test{i} = standardize(data_in{i}(model.ind{3}{i}, :), 1);
    end
end


if model.sbp
    dat_norm = sum(dat_norm)*ones(num_mod,1);
end

for t = 1:model.T
    latent_prev = model.X;
%     a_prev{t} = params(1).a;
    fprintf('\r######################\r');
    fprintf('No. of ADM cycle %i\r', t);
    fprintf('\rUpdating latent space and hyper-parameters\r');
    model = ready2min(data_in, model);      % updated the latent space and the hyperparameters
    
    fX(t) = model.fX;
    err(t) = norm(model.X - latent_prev,'fro')/norm(latent_prev, 'fro');    % change of the latent space
    
    if ~model.bp    
        fprintf('\rUpdating back-mappings\r');
        model.bp_params = update_bp_params(Y, model);
        
        [model.adm_params, L_adm] = update_adm_params(model);
        L(t) = fX(t) + L_adm;       % include the neg. log-likelihood in the augmented Lagrangian
    end
    model = ds_gplvm_test(Y, model, Y_val, Y_test);
        
    
%%%%%%%%%%%%% PLOTS %%%%%%%%%%%%%%%%%%%
if model.verbose && ~model.bp
    colors = ['b','k','r','g','c','m'];
    syms = {'.-','s-','v-' 'x-' '+-' 'o-'};
    figure(1);
    semilogy(fX, '.-b'); hold on
    semilogy(L, '.-k');
    hold off; drawnow;
    xlabel('Number of ADM cycle')
    ylabel('Cost function')
    legend('Negative log-likelihood', 'Augmented Lagrangian')
    
    figure(2);
    if model.sbp
        plot(model.adm_params(1).norm/dat_norm(1), '.-b');
    elseif model.ibp
        hold off; hold on
        for i = 1:num_mod
            plot(model.adm_params(i).norm/dat_norm(i), [colors(i) syms{1}]);
            legendInfo{i} = ['View ' num2str(i)];
        end
        hold off; drawnow;
        legend(legendInfo)
    end
    xlabel('Number of ADM cycle')
    ylabel('Norm of back projections')
    figure(3);
    plot(err, '.-k'); 
    xlabel('Number of ADM cycle')
    ylabel('Change of latent space')
    drawnow;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if err(t)<1e-3 && t>1, break; end

end
end
