function writeMerlBrdf(img, outname)

% Read a predicted BRDF to a binary file.
% Same format as in MERL used.

sample = zeros(1, 180*90*90*3);
for i = 1:90
    for j = 1:90
        for k = 1:180
            rIdx = (k-1) + (j-1)*180 + (i-1)*180*90 + 1;
            sample(1, rIdx) = img(i, j, k, 1) / (1/1500);
            gIdx = rIdx + 180*90*90;
            sample(1, gIdx) = img(i, j, k, 2) / (1.15/1500);
            bIdx = rIdx + 180*90*90*2;
            sample(1, bIdx) = img(i, j, k, 3) / (1.66/1500);
        end
    end
end

sample(sample < 0) = -1;

fileId = fopen(outname, 'w');
fwrite(fileId, [90 90 180], 'int32');
fwrite(fileId, sample, 'double');
fclose(fileId);

end