function brdf = readMerlBrdf(filename)

% Read a MERL BRDF from a binary file.

% Read brdf from binary file
fid = fopen(filename, 'rb');
dims = fread(fid, 3, 'uint32');
n = dims(1)*dims(2)*dims(3);
brdf_temp = fread(fid, 3*n, 'double');
fclose(fid);

% Save format: brdf(theta_half, theta_diff, phi_diff, RGB)
brdf(:,:,:,1) = permute(reshape(brdf_temp(1:n),180,90,90), [3 2 1]) * (1.0/1500);
brdf(:,:,:,2) = permute(reshape(brdf_temp(n+1:2*n),180,90,90), [3 2 1]) * (1.15/1500);
brdf(:,:,:,3) = permute(reshape(brdf_temp(2*n+1:3*n),180,90,90), [3 2 1]) * (1.66/1500);
brdf(brdf<0) = -1;

end