function model = initialize_dsgplvm(data_in, model)

% Modified version of the original initialize_dsgplvm.m of Eleftheriadis.
% It has been modified to include PCA in the prior.
%
% Initializes the DS-GPLVM. The latent space is initialized to LPP/LDA
% projections of the input data. Also the parameters of the back-mappings
% and the ADM procedure are set to their defaults.

%% Prepare data
if numel(data_in) == 1
    Y_tmp = standardize(data_in{1}(model.ind{1},:), 1);
else
    Y_tmp = [];
    for i = 1:numel(data_in)
        Y_tmp = [Y_tmp standardize(data_in{i}(model.ind{1},:), 0)];
    end
    Y_tmp = standardize(Y_tmp, 1);
%     Y_tmp = standardize(data_in{2}(model.ind{1},:), 0);
end

%% Initialize the space from lda or lpp
labels = model.labels_full{1}(model.ind{1});
switch model.prior_type
    case 'lda'
        disp('Initializing manifold based on LDA...');
        [X_init, model.mapping] = myLDA(Y_tmp, labels);
    case 'lpp'
        disp('Initializing manifold based on LPP...');
        model.Laplacian = gmrf_create_L(labels, data_in, model.ind{1});
        [X_init, model.mapping] = myLPP(Y_tmp, model.Laplacian, 5);
    case 'pca'
        disp('Initializing manifold based on PCA...');
        tmp_mdl = myPCA(Y_tmp, .99);
        X_init = tmp_mdl.params;
        model.mapping = tmp_mdl.eigenvectors;
end

model.X_init = X_init;      % initial instance of the latent space

X_init = standardize(X_init, 1);
model.X = X_init;           % current state of the space

%% Initialize length scale from median distance
for i = 1:numel(data_in)
    hyp{i} = model.hyp;
    hyp{i}.cov(1) = log(find_heuristic_ell(model.X'));
end
model.hyp = hyp;

%% Initialize parameters for back-mappings and ADM
model = initialize_params(data_in, model);

end