function [f, df] = ds_gplvm_fun(X, data_in, model)

% Modified version of the original ds_gplvm_fun.m of Eleftheriadis. It has
% been modified to include PCA in the prior.
%
% Calculates the negative log-likelihood of the model, f, and its
% derivatives, df, w.r.t the parameter set X.

num_mod = numel(data_in);
[N,D] = size(model.X);

cov_param = eval(feval(model.covfunc{:}));
lik_param = eval(feval(model.likfunc));
total_num_hyp = num_mod * (cov_param + lik_param);

for i = 1:num_mod
    Y{i} = standardize(data_in{i}(model.ind{1},:), 1);
end

%% %%%%%%%%%%%%% BC %%%%%%%%%%%%%%%%%%%%%
if model.bp
    tmp_A = reshape(X(1:N*D+D), N+1, D);
    X_hyp = X(N*D+D+1:end);
    X_real = [model.bp_params.K ones(N,1)] * tmp_A;
    X = [X_real(:); X_hyp(:)];
end

%% %%%%%%%%%%%%% GPLVM %%%%%%%%%%%%%%%%%%
X_gplvm = X(1:N*D + total_num_hyp);
[f, df] = gplvm(X_gplvm, @infExact_mod, [], model.covfunc, model.likfunc, Y);

%% %%%%%%%%%%%% PRIOR %%%%%%%%%%%%%%%%%%%%
if model.prior
    tmp_X = reshape(X(1:N*D), N, D);
    switch model.prior_type
        case 'lda'
            clusters = length(unique(model.labels_full{1}(model.ind{1})));
            labels_map = zeros(N, clusters);
            for c = 1:clusters
                labels_map(:, c) = model.labels_full{1}(model.ind{1}) == c;
            end
            N_c = 1./sum(labels_map); N_c = diag(N_c);
            W = labels_map * N_c * labels_map';
            W = eye(N) - W;
            S_w = tmp_X' * W * tmp_X / N;
            W_g = ones(N,1) * ones(1,N) / N;
            W_g = eye(N) - W_g;
            S_t = tmp_X' * W_g * tmp_X / N;
            S_b = S_t - S_w;
            B = W_g - W;
            
            f = f + model.prior * trace(S_b \ S_w);
            
            df_prior = model.prior * (-2*B*tmp_X / S_b * S_w / S_b + 2*W*tmp_X / S_b) / N;
        case 'lpp'
            f = f + .5 * model.prior * trace(tmp_X' * model.Laplacian * tmp_X);
            df_prior = model.prior * model.Laplacian * tmp_X;
        case 'pca'
            f = f + .5 * model.prior * trace(tmp_X' * tmp_X);
            df_prior = model.prior * tmp_X;
    end
    df(1:N*D) = df(1:N*D) + df_prior(:);
end

%% %%%%%%%%%%%%% BC AGAIN %%%%%%%%%%%%%%%%%%%%%
if model.bp
    tmp_df = reshape(df(1:N*D), N, D);
    real_df = [model.bp_params.K; ones(1,N)]*tmp_df;
    bias_df = [];
    df = [real_df(:); bias_df(:); df(N*D+1:end)];
end

%% %%%%%%%%%%%%%%% ADM %%%%%%%%%%%%%%%%%%%%%%%%
if model.sbp || model.ibp
    X_adm = reshape(X(1:N*D), N,D);
    f_adm = 0; df_adm_x = 0;
    
    if model.sbp
        f_adm = trace(model.adm_params(1).Lambda'*(X_adm - model.bp_params(1).M(1:N,:) * model.bp_params(1).A)) + ...
            model.adm_params(1).mu/2 * (norm(X_adm - model.bp_params(1).M(1:N,:) * model.bp_params(1).A, 'fro'))^2;
        df_adm_x = model.adm_params(1).Lambda + model.adm_params(1).mu * (X_adm - model.bp_params(1).M(1:N,:) * model.bp_params(1).A);
    else
        for i = 1:num_mod
            f_adm = f_adm + model.adm_params(i).mu/2*norm(X_adm - model.bp_params(i).M(1:N,:)*model.bp_params(i).A,'fro')^2 + ...
                trace(model.adm_params(i).Lambda'*(X_adm - model.bp_params(i).M(1:N,:) * model.bp_params(i).A));
            df_adm_x = df_adm_x + model.adm_params(i).mu * (X_adm - model.bp_params(i).M(1:N,:)*model.bp_params(i).A) + ...
                model.adm_params(i).Lambda;
        end
    end
    f = f + f_adm;
    df(1:N*D) = df(1:N*D) + df_adm_x(:);
end

end
